unit Main;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    MainMenu2: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileNewItem1: TMenuItem;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    SpeedPanel: TPanel;
    OpenBtn: TSpeedButton;
    ExitBtn: TSpeedButton;
    StatusBar: TStatusBar;
    SpeedButton1: TSpeedButton;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem6: TMenuItem;
    window2: TMenuItem;
    MenuItem8: TMenuItem;
    MenuItem9: TMenuItem;
    MenuItem10: TMenuItem;
    MenuItem11: TMenuItem;
    MenuItem12: TMenuItem;
    MenuItem13: TMenuItem;
    Rajzok1: TMenuItem;
    Ellipszisszelet1: TMenuItem;
    Ellipszis1: TMenuItem;
    Ellipsziscikk1: TMenuItem;
    Poligon1: TMenuItem;
    Tglalap1: TMenuItem;
    KerTgla1: TMenuItem;
    Vonal1: TMenuItem;
    sszes1: TMenuItem;
    Semelyik1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FileNewItemClick(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FileNewItem1Click(Sender: TObject);
    procedure Ellipszisszelet1Click(Sender: TObject);
    procedure Ellipszis1Click(Sender: TObject);
    procedure Ellipsziscikk1Click(Sender: TObject);
    procedure Poligon1Click(Sender: TObject);
    procedure Tglalap1Click(Sender: TObject);
    procedure KerTgla1Click(Sender: TObject);
    procedure Vonal1Click(Sender: TObject);
    procedure sszes1Click(Sender: TObject);
    procedure Semelyik1Click(Sender: TObject);
  private
    { Private declarations }
    procedure CreateMDIChild(const Name: string);
    procedure CreateMDIChild1(const Name: string);
    procedure ShowHint(Sender: TObject);
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses ChildWin, Childwin1, About;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  //magyarz szveg engedlyezse
  Application.OnHint := ShowHint;
  //az ablakmen
  Screen.OnActiveFormChange := UpdateMenuItems;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TMainForm.CreateMDIChild(const Name: string);
var
  Child: TMDIChild;
begin
  // j MDI firkapapr
  Child := TMDIChild.Create(Application);
  Child.Caption := Name;
end;

procedure TMainForm.CreateMDIChild1(const Name: string);
var
  Child: TMDIChild1;
begin
  // j Rajzlap
  Child := TMDIChild1.Create(Application);
  Child.Caption := Name;
end;

procedure TMainForm.FileNewItemClick(Sender: TObject);
begin
  CreateMDIChild('j firkapapir' + IntToStr(MDIChildCount + 1));
end;


procedure TMainForm.FileCloseItemClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
    ActiveMDIChild.Close;
end;

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
  Close;
end;


procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  // Visszafel az MDI ablakokon
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TMainForm.UpdateMenuItems(Sender: TObject);
begin
  //zrs
  FileCloseItem.Enabled := MDIChildCount > 0;
  //tlapols
  WindowCascadeItem.Enabled := MDIChildCount > 0;
  //egyms mell rendezs
  WindowTileItem.Enabled := MDIChildCount > 0;
  //ikonok elrendezse
  WindowArrangeItem.Enabled := MDIChildCount > 0;
  //minimalizls
  WindowMinimizeItem.Enabled := MDIChildCount > 0;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;

procedure TMainForm.HelpAboutItemClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainForm.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
   Mainform.Statusbar.SimpleText:='';
end;

procedure TMainForm.FileNewItem1Click(Sender: TObject);
begin
  CreateMDIChild1('j rajzlap' + IntToStr(MDIChildCount + 1));
end;


procedure TMainForm.Ellipszisszelet1Click(Sender: TObject);
begin
  TMDIChild1(Mainform.ActiveMdiChild).Chord:=not(TMDIChild1(Mainform.ActiveMdiChild).Chord);
  Mainform.Ellipszisszelet1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Chord;
  TMDIChild1(Mainform.ActiveMdiChild).Refresh;

end;

procedure TMainForm.Ellipszis1Click(Sender: TObject);
begin
  TMDIChild1(Mainform.ActiveMdiChild).Ellipse:=not(TMDIChild1(Mainform.ActiveMdiChild).Ellipse);
  Mainform.Ellipszis1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Ellipse;
  TMDIChild1(Mainform.ActiveMdiChild).Refresh;
end;

procedure TMainForm.Ellipsziscikk1Click(Sender: TObject);
begin
  TMDIChild1(Mainform.ActiveMdiChild).Pie:=not(TMDIChild1(Mainform.ActiveMdiChild).Pie);
  Mainform.Ellipsziscikk1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Pie;
  TMDIChild1(Mainform.ActiveMdiChild).Refresh;
end;

procedure TMainForm.Poligon1Click(Sender: TObject);
begin
  TMDIChild1(Mainform.ActiveMdiChild).Polygon:=not(TMDIChild1(Mainform.ActiveMdiChild).Polygon);
  Mainform.Poligon1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Polygon;
  TMDIChild1(Mainform.ActiveMdiChild).Refresh;
end;

procedure TMainForm.Tglalap1Click(Sender: TObject);
begin
  TMDIChild1(Mainform.ActiveMdiChild).Rectangle:=not(TMDIChild1(Mainform.ActiveMdiChild).Rectangle);
  Mainform.Tglalap1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Rectangle;
  TMDIChild1(Mainform.ActiveMdiChild).Refresh;
end;

procedure TMainForm.KerTgla1Click(Sender: TObject);
begin
  TMDIChild1(Mainform.ActiveMdiChild).RoundRect:=not(TMDIChild1(Mainform.ActiveMdiChild).RoundRect);
  Mainform.KerTgla1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Rectangle;
  TMDIChild1(Mainform.ActiveMdiChild).Refresh;

end;

procedure TMainForm.Vonal1Click(Sender: TObject);
begin
  TMDIChild1(Mainform.ActiveMdiChild).Line:=not(TMDIChild1(Mainform.ActiveMdiChild).Line);
  Mainform.Vonal1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Line;
  TMDIChild1(Mainform.ActiveMdiChild).Refresh;

end;

procedure TMainForm.sszes1Click(Sender: TObject);
begin
  TMDIChild1(Mainform.ActiveMdiChild).Chord:=true;
  Mainform.Ellipszisszelet1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Chord;
  TMDIChild1(Mainform.ActiveMdiChild).Ellipse:=true;
  Mainform.Ellipszis1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Ellipse;
  TMDIChild1(Mainform.ActiveMdiChild).Pie:=true;
  Mainform.Ellipsziscikk1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Pie;
  TMDIChild1(Mainform.ActiveMdiChild).Polygon:=true;
  Mainform.Poligon1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Polygon;
  TMDIChild1(Mainform.ActiveMdiChild).Rectangle:=true;
  Mainform.Tglalap1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Rectangle;
  TMDIChild1(Mainform.ActiveMdiChild).RoundRect:=true;
  Mainform.KerTgla1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Rectangle;
  TMDIChild1(Mainform.ActiveMdiChild).Line:=true;
  Mainform.Vonal1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Line;
  TMDIChild1(Mainform.ActiveMdiChild).Refresh;
end;

procedure TMainForm.Semelyik1Click(Sender: TObject);
begin
  TMDIChild1(Mainform.ActiveMdiChild).Chord:=false;
  Mainform.Ellipszisszelet1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Chord;
  TMDIChild1(Mainform.ActiveMdiChild).Ellipse:=false;
  Mainform.Ellipszis1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Ellipse;
  TMDIChild1(Mainform.ActiveMdiChild).Pie:=false;
  Mainform.Ellipsziscikk1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Pie;
  TMDIChild1(Mainform.ActiveMdiChild).Polygon:=false;
  Mainform.Poligon1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Polygon;
  TMDIChild1(Mainform.ActiveMdiChild).Rectangle:=false;
  Mainform.Tglalap1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Rectangle;
  TMDIChild1(Mainform.ActiveMdiChild).RoundRect:=false;
  Mainform.KerTgla1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Rectangle;
  TMDIChild1(Mainform.ActiveMdiChild).Line:=false;
  Mainform.Vonal1.Checked:=TMDIChild1(Mainform.ActiveMdiChild).Line;
  TMDIChild1(Mainform.ActiveMdiChild).Refresh;

end;

end.
